/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AbstractClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MfaClassVisitor
extends AbstractClassVisitor {
    public MfaClassVisitor(IClassMetricsContainer mc) {
        super(mc);
    }

    private int howManyIgnore(Method[] methods) {
        int ign = 0;
        for (Method m : methods) {
            if (!m.getName().equals("<init>") && !m.getName().equals("<clinit>")) continue;
            ++ign;
        }
        return ign;
    }

    private int getNumOfMethods(JavaClass jc) {
        if (jc.getClassName().compareTo("java.lang.Object") == 0) {
            return 0;
        }
        Method[] methods = jc.getMethods();
        return methods.length - this.howManyIgnore(methods);
    }

    protected void visitJavaClass_body(JavaClass jc) {
        JavaClass[] parents;
        JavaClass parent = jc.getSuperClass();
        double pNumOfMeth = 0.0;
        for (JavaClass p : parents = jc.getSuperClasses()) {
            pNumOfMeth += (double)this.getNumOfMethods(p);
        }
        double cNumOfMeth = this.getNumOfMethods(jc);
        double result = cNumOfMeth + pNumOfMeth == 0.0 ? 0.0 : pNumOfMeth / (cNumOfMeth + pNumOfMeth);
        this.mClassMetrics.setMfa(result);
    }
}

