/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AbstractClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import gr.spinellis.ckjm.utils.LoggerHelper;
import org.apache.bcel.classfile.JavaClass;

public class AmcClassVisitor
extends AbstractClassVisitor {
    public AmcClassVisitor(IClassMetricsContainer container) {
        super(container);
    }

    protected void visitJavaClass_body(JavaClass jc) {
        double result;
        double numberOfFields = jc.getFields().length;
        double wmc = this.mClassMetrics.getWmc();
        double loc = this.mClassMetrics.getLoc();
        if (wmc == 0.0) {
            result = 0.0;
        } else if ((loc = loc - numberOfFields - wmc) < 0.0) {
            LoggerHelper.printError("The AMC metric probably is being counted before WMC or LOC!", new RuntimeException());
            result = 0.0;
        } else {
            result = loc / wmc;
        }
        this.mClassMetrics.setAmc(result);
    }
}

