/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.utils;

import gr.spinellis.ckjm.utils.LoggerHelper;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvoktion
implements Comparable<MethodInvoktion> {
    private String mDestClass;
    private String mDestMethod;
    private Type[] mDestMethodArgs;
    private String mSrcClass;
    private String mSrcMethod;
    private Type[] mSrcMethodArgs;

    public MethodInvoktion(String destClass, String destMethod, Type[] destArgs, String srcClass, String srcMethod, Type[] srcArgs) {
        this.mDestClass = destClass;
        this.mDestMethod = destMethod;
        this.mDestMethodArgs = destArgs;
        this.mSrcClass = srcClass;
        this.mSrcMethod = srcMethod;
        this.mSrcMethodArgs = srcArgs;
    }

    public void setDestClass(String destClass) {
        if (destClass == null) {
            LoggerHelper.printError("Destination class shouldn't be setted to null in the MethodInvokation class!", new RuntimeException());
        }
        this.mDestClass = destClass;
    }

    public String getDestClass() {
        return this.mDestClass;
    }

    public String getDestMethod() {
        return this.mDestMethod;
    }

    public Type[] getDestMethodArgs() {
        return this.mDestMethodArgs;
    }

    public boolean isNotConstructorInvocation() {
        return !this.mDestMethod.equals("<init>") && !this.mDestMethod.equals("<clinit>");
    }

    public String toString() {
        return this.mDestClass + "." + this.mDestMethod + "(" + this.mDestMethodArgs.length + ")";
    }

    public String getSrcClass() {
        return this.mSrcClass;
    }

    public String getSrcMethod() {
        return this.mSrcMethod;
    }

    public Type[] getSrcMethodArgs() {
        return this.mSrcMethodArgs;
    }

    @Override
    public int compareTo(MethodInvoktion mi) {
        int sum = this.mDestClass.compareTo(mi.getDestClass());
        sum += this.mDestMethod.compareTo(mi.getDestMethod());
        sum += this.mSrcClass.compareTo(mi.getSrcClass());
        sum += this.mSrcMethod.compareTo(mi.getSrcMethod());
        String destArgsLocal = this.typesToString(this.mDestMethodArgs);
        String destArgsParam = this.typesToString(mi.getDestMethodArgs());
        sum += destArgsLocal.compareTo(destArgsParam);
        String srcArgsLocal = this.typesToString(this.mSrcMethodArgs);
        String srcArgsParam = this.typesToString(mi.getSrcMethodArgs());
        return sum += srcArgsLocal.compareTo(srcArgsParam);
    }

    private String typesToString(Type[] types) {
        StringBuilder sb = new StringBuilder();
        for (Type t : types) {
            sb.append(t.getSignature());
        }
        return sb.toString();
    }
}

