/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AmcClassVisitor;
import gr.spinellis.ckjm.CamClassVisitor;
import gr.spinellis.ckjm.CkjmOutputHandler;
import gr.spinellis.ckjm.ClassMetricsContainer;
import gr.spinellis.ckjm.ClassVisitor;
import gr.spinellis.ckjm.DamClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import gr.spinellis.ckjm.ICountingProperities;
import gr.spinellis.ckjm.IcAndCbmClassVisitor;
import gr.spinellis.ckjm.LocClassVisitor;
import gr.spinellis.ckjm.MfaClassVisitor;
import gr.spinellis.ckjm.MoaClassVisitor;
import gr.spinellis.ckjm.PrintPlainResults;
import gr.spinellis.ckjm.ant.PrintXmlResults;
import gr.spinellis.ckjm.utils.CmdLineParser;
import gr.spinellis.ckjm.utils.LoggerHelper;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class MetricsFilter
implements ICountingProperities {
    private boolean mIncludeJdk = false;
    private boolean mOnlyPublic = false;
    private MoaClassVisitor mMoaVisitor;
    private IClassMetricsContainer mMetricsContainer = new ClassMetricsContainer(this);

    public boolean isJdkIncluded() {
        return this.mIncludeJdk;
    }

    public boolean includeAll() {
        return !this.mOnlyPublic;
    }

    public MetricsFilter() {
        this.mMoaVisitor = new MoaClassVisitor(this.mMetricsContainer);
    }

    void processClass(String clspec) {
        JavaClass jc = null;
        if (clspec.toLowerCase().endsWith(".jar")) {
            try {
                JarFile jf = new JarFile(clspec);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String cl = entries.nextElement().getName();
                    if (!cl.toLowerCase().endsWith(".class")) continue;
                    try {
                        jc = new ClassParser(clspec, cl).parse();
                        this.processClass(jc);
                    }
                    catch (IOException e) {
                        LoggerHelper.printError("Error loading " + cl + " from " + clspec + ": " + e);
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MetricsFilter.class.getName()).log(Level.SEVERE, "Unable to load jar file " + clspec, ex);
            }
        } else {
            try {
                jc = new ClassParser(clspec).parse();
                this.processClass(jc);
            }
            catch (IOException e) {
                LoggerHelper.printError("Error loading " + clspec + ": " + e);
            }
        }
    }

    public static void runMetrics(String[] files, CkjmOutputHandler outputHandler, boolean includeJDK) {
        MetricsFilter mf = new MetricsFilter();
        mf.mIncludeJdk = includeJDK;
        mf.runMetricsInternal(files, outputHandler);
    }

    private void processClass(JavaClass jc) {
        if (jc != null) {
            ClassVisitor visitor = new ClassVisitor(jc, this.mMetricsContainer, this);
            visitor.start();
            visitor.end();
            LocClassVisitor locVisitor = new LocClassVisitor(this.mMetricsContainer);
            locVisitor.visitJavaClass(jc);
            DamClassVisitor damVisitor = new DamClassVisitor(jc, this.mMetricsContainer);
            damVisitor.visitJavaClass(jc);
            this.mMoaVisitor.visitJavaClass(jc);
            MfaClassVisitor mfaVisitor = new MfaClassVisitor(this.mMetricsContainer);
            mfaVisitor.visitJavaClass(jc);
            CamClassVisitor camVisitor = new CamClassVisitor(this.mMetricsContainer);
            camVisitor.visitJavaClass(jc);
            IcAndCbmClassVisitor icVisitor = new IcAndCbmClassVisitor(this.mMetricsContainer);
            icVisitor.visitJavaClass(jc);
            AmcClassVisitor amcVisitor = new AmcClassVisitor(this.mMetricsContainer);
            amcVisitor.visitJavaClass(jc);
        }
    }

    private void runMetricsInternal(String[] files, CkjmOutputHandler outputHandler) {
        for (int i = 0; i < files.length; ++i) {
            this.processClass(files[i]);
        }
        this.mMoaVisitor.end();
        this.mMetricsContainer.printMetrics(outputHandler);
    }

    public static void main(String[] argv) {
        MetricsFilter mf = new MetricsFilter();
        CmdLineParser cmdParser = new CmdLineParser();
        cmdParser.parse(argv);
        if (cmdParser.isArgSet("s")) {
            mf.mIncludeJdk = true;
        }
        if (cmdParser.isArgSet("p")) {
            mf.mOnlyPublic = true;
        }
        CkjmOutputHandler handler = cmdParser.isArgSet("x") ? new PrintXmlResults(new PrintStream(System.out)) : new PrintPlainResults(System.out);
        String[] tmp = new String[1];
        mf.runMetricsInternal(cmdParser.getClassNames().toArray(tmp), handler);
    }
}

