/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.AbstractClassVisitor;
import gr.spinellis.ckjm.IClassMetricsContainer;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;

public class LocClassVisitor
extends AbstractClassVisitor {
    public LocClassVisitor(IClassMetricsContainer classMap) {
        super(classMap);
    }

    protected void visitJavaClass_body(JavaClass jc) {
        this.mClassMetrics.addLoc(jc.getFields().length);
        Method[] methods = jc.getMethods();
        this.mClassMetrics.addLoc(methods.length);
        for (Method m : methods) {
            m.accept(this);
        }
    }

    public void visitMethod(Method meth) {
        MethodGen mg = new MethodGen(meth, this.mClassName, this.mPoolGen);
        InstructionList il = mg.getInstructionList();
        if (il != null) {
            int instr = il.getLength();
            this.mClassMetrics.addLoc(instr);
        }
    }
}

